--### Zuri Thu 05/22/2025 10:14:22.11 ###  
--### Zuri9.2025R1.01 ###  
--### 30 WFForms Report ##############################################################################

--#####################################################################################################################
--***** TABELAS FORMS *************************************************************************************************
--#####################################################################################################################

IF OBJECT_ID('FFOR_FORMULARIO') IS NULL
	CREATE TABLE [FFOR_FORMULARIO] (
		[FOR_N_CODIGO] [int] IDENTITY (1, 1) NOT NULL ,
		[FOR_N_POR_N_CODIGO] [int] NOT NULL ,
		[FOR_N_ARE_N_CODIGO] [int] NOT NULL ,
		[FOR_C_TITULO] [nvarchar] (60)  NOT NULL ,
		[FOR_C_APELIDO] [varchar] (100)  NOT NULL ,
		[FOR_B_SYSTEMFORM] [bit] NOT NULL ,
		[FOR_B_USEWORKFLOW] [bit] NOT NULL ,
		[FOR_C_LAYOUT] VARCHAR(MAX) NULL,
		[FOR_C_DATASOURCES] VARCHAR(MAX) NULL,
		[FOR_C_CONFIGURATION] VARCHAR(MAX) NULL,
		[FOR_C_EXECCONFIG] VARCHAR(MAX) NULL,
		[FOR_N_USU_EDITOR] INT NULL,
		[FOR_D_EDICAO] DATETIME NULL,
		[FOR_D_PUBLICACAO] DATETIME NULL,
		[FOR_N_USU_PUBLICADOR] INT NULL,
		CONSTRAINT [PK_FFOR_FORMULARIO] PRIMARY KEY  CLUSTERED ([FOR_N_CODIGO])   
	) 
GO

IF OBJECT_ID('FPFR_PUBLISHED_FORM') IS NULL
	CREATE TABLE [FPFR_PUBLISHED_FORM] (
		[PFR_N_ID] [int] IDENTITY (1, 1) NOT NULL ,
		[PFR_FOR_N_ID] [int] NOT NULL,
		[PFR_C_APELIDO] [varchar] (100)  NOT NULL ,
		[PFR_N_VERSION] [int] NOT NULL,
		[PFR_C_COMMENT] VARCHAR(MAX) NULL,
		[PFR_C_LAYOUT] VARCHAR(MAX) NULL,
		[PFR_C_DATASOURCES] VARCHAR(MAX) NULL,
		[PFR_C_CONFIGURATION] VARCHAR(MAX) NULL,
		[PFR_C_EXECCONFIG] VARCHAR(MAX) NULL,
		[PFR_C_CRUDSOURCE] VARCHAR(MAX) NULL,
		[PFR_C_CONTROLUI] VARCHAR(MAX) NULL,
		[PFR_C_GRIDCONTROLUI] VARCHAR(MAX) NULL,
		[PFR_D_PUBLICACAO] DATETIME NULL,
		[PFR_N_USU_PUBLICADOR] INT NULL,
		CONSTRAINT [PK_FPFR_PUBLISHED_FORM] PRIMARY KEY  CLUSTERED ([PFR_N_ID]),
		CONSTRAINT [FK_FPFR_FFOR_FORMULARIO] FOREIGN KEY(PFR_FOR_N_ID)
			REFERENCES [FFOR_FORMULARIO] (FOR_N_CODIGO) ON DELETE CASCADE
	) 
GO

IF OBJECT_ID('FFXW_FORMULARIO_WORKFLOW') IS NULL
	CREATE TABLE [FFXW_FORMULARIO_WORKFLOW] (
		FXW_N_ID INT IDENTITY,
		[FXW_N_NODE_ID] [int] NOT NULL ,
		[FXW_C_FOR_C_APELIDO] [varchar] (100)  NOT NULL ,
		[FXW_N_MULTIPLO] [smallint] NOT NULL ,
		[FXW_C_ACESSO_ANEXO] [varchar] (100)  NULL ,
		[FXW_C_DADOS] [text]  NULL ,
		[FXW_C_DIV] [varchar] (4000) NULL ,
		[FXW_C_DIVEDIT] [varchar] (4000) NULL,
		CONSTRAINT PK_FFXW PRIMARY KEY (FXW_N_ID)
	)  
GO

IF EXISTS (SELECT 1 FROM SYS.COLUMNS WHERE NAME = 'FXW_C_FOR_C_APELIDO' AND OBJECT_ID = OBJECT_ID('FFXW_FORMULARIO_WORKFLOW') AND COL_LENGTH('FFXW_FORMULARIO_WORKFLOW', 'FXW_C_FOR_C_APELIDO')<=30)
BEGIN
	ALTER TABLE [FFXW_FORMULARIO_WORKFLOW] ALTER COLUMN [FXW_C_FOR_C_APELIDO] VARCHAR(100) NOT NULL
END
GO

IF OBJECT_ID('FFXI_FORMULARIO_ITEM_PROCESSO') IS NULL
	CREATE TABLE [FFXI_FORMULARIO_ITEM_PROCESSO] (
		[FXI_N_ITE_N_CODIGO] [int] NOT NULL ,
		[FXI_N_FOR_N_CODAUTOMATICO] [int] NOT NULL ,
		[FXI_C_FOR_C_APELIDO] [varchar] (100)  NOT NULL ,
		[FXI_C_FOR_C_GUID] [varchar] (36) NOT NULL,
		FXI_ISP_N_ID	INT,
		CONSTRAINT [PK_FFXI_FORMULARIO_ITEM_PROCESSO] PRIMARY KEY  CLUSTERED 
		(
			[FXI_N_ITE_N_CODIGO],
			[FXI_N_FOR_N_CODAUTOMATICO],
			[FXI_C_FOR_C_APELIDO],
			[FXI_C_FOR_C_GUID]
		)   
	) 
GO

IF OBJECT_ID('FFXI_FORM_ITEMWORKFLOW') IS NULL
	CREATE TABLE FFXI_FORM_ITEMWORKFLOW (
		FXI_N_ID INT IDENTITY,
		[FXI_IWF_N_ID] [int] NOT NULL,
		[FXI_ISP_N_ID] [int] NOT NULL,
		[FXI_FRM_N_ITEMID] [int] NOT NULL,
		[FXI_PFR_C_APELIDO] [varchar] (100)  NOT NULL ,
		[FXI_PFR_N_VERSION] [int] NOT NULL,
		[FXI_D_GRAVACAO] DATETIME NOT NULL,
		[FXI_N_USERID] INT NOT NULL,
		CONSTRAINT PK_FFXI_IDENTIFIER PRIMARY KEY (FXI_N_ID)
	) 
GO

IF EXISTS (SELECT 1 FROM SYS.COLUMNS WHERE NAME = 'FXI_C_FOR_C_APELIDO' AND OBJECT_ID = OBJECT_ID('FFXI_FORMULARIO_ITEM_PROCESSO') AND COL_LENGTH('FFXI_FORMULARIO_ITEM_PROCESSO', 'FXI_C_FOR_C_APELIDO')<=30)
BEGIN
	ALTER TABLE [FFXI_FORMULARIO_ITEM_PROCESSO] ALTER COLUMN [FXI_C_FOR_C_APELIDO] VARCHAR(100) NOT NULL
END
GO

IF OBJECT_ID('FFCW_FORMCHILDWORKFLOW') IS NULL
CREATE TABLE [FFCW_FORMCHILDWORKFLOW](
	FCW_ATV_N_CODIGO		INT NOT NULL,
	FCW_C_ATTACHALIAS		NVARCHAR(50),
	FCW_B_ISPARENTMULTIPLE	BIT,
	FCW_C_CHILDALIAS		NVARCHAR(150),
	FCW_C_PARENTALIAS		NVARCHAR(150),
	FCW_N_PARENTACTIVITYID	INT,
	FCW_C_PARENTCONTROL		NVARCHAR(50),
	FCW_C_ACCESSLIST		NVARCHAR(300),
	CONSTRAINT PK_FCW_ATV_N_CODIGO PRIMARY KEY (FCW_ATV_N_CODIGO)
)


IF NOT EXISTS (SELECT * FROM sys.columns where name = 'PFR_C_COMMENT')
BEGIN 
	ALTER TABLE FPFR_PUBLISHED_FORM  ADD PFR_C_COMMENT VARCHAR(MAX) NULL
END
GO

IF OBJECT_ID('FFWF_FORMWORKFLOW') IS NULL
CREATE TABLE [FFWF_FORMWORKFLOW](
	FWF_ATV_N_CODIGO		[int] NOT NULL,
	FWF_FOR_N_ID			[int] NOT NULL,
	FWF_C_FORMALIAS			[varchar] (100)  NOT NULL,
	FWF_C_MODULEIDENTIFIER	[varchar] (40)  NOT NULL,
	CONSTRAINT PK_FFWF_FORMWORKFLOW PRIMARY KEY (FWF_ATV_N_CODIGO),
	CONSTRAINT [FK_FFWF_FFOR_FORMULARIO] FOREIGN KEY(FWF_FOR_N_ID) REFERENCES [FFOR_FORMULARIO] (FOR_N_CODIGO)
)


--#####################################################################################################################
--***** TABELAS REPORTS ***********************************************************************************************
--#####################################################################################################################
IF OBJECT_ID('RREP_REPORTS') IS NULL
	CREATE TABLE RREP_REPORTS (
		REP_N_ID INT IDENTITY,
		REP_N_MOI_N_CODIGO int NOT NULL ,
		REP_N_FOR_N_CODIGO int NULL ,
		REP_C_TITULO nvarchar (100)  NULL ,
		REP_N_PAGECOUNT int NULL ,
		REP_N_TIPO char (2)  NOT NULL ,
		REP_C_PARAMETROS varchar (2000)  NULL ,
		REP_C_PROCEDURE varchar (200)  NULL ,
		REP_C_LISTAEDICAO varchar (200)  NOT NULL ,
		REP_C_LISTAEXCLUSAO varchar (200)  NOT NULL ,
		REP_C_CONNECTION varchar (400)  NULL , 
		REP_C_TITULOGRAFICO	nvarchar (100)  NULL ,
		REP_N_VISUALIZACAOGRAFICO INT NULL ,
		REP_N_LARGURAGRAFICO INT NULL , 
		REP_N_ALTURAGRAFICO INT NULL,
		REP_B_MOSTRARVALORESGRAFICO BIT NULL ,
		REP_C_CAMPONOMEGRAFICO VARCHAR(200) NULL ,
		REP_C_CAMPOVALORGRAFICO VARCHAR(200) NULL ,
		REP_C_POSICAOLEGENDAGRAFICO INT NULL ,
		REP_C_FUNCAOAGRUPAMENTOGRAFICO INT NULL , 
		REP_C_CAMPOAGRUPAMENTO VARCHAR(300) NULL,
		REP_B_VISUALIZAGRAFICO BIT NOT NULL DEFAULT 0,
		CONSTRAINT PK_RREP PRIMARY KEY (REP_N_ID)
	)
GO

ALTER TABLE RREP_REPORTS
ALTER COLUMN REP_C_TITULO VARCHAR(200)
GO

ALTER TABLE RREP_REPORTS
ALTER COLUMN REP_C_PARAMETROS VARCHAR(2000)
GO

ALTER TABLE RREP_REPORTS
ALTER COLUMN REP_C_PROCEDURE VARCHAR(200)
GO

ALTER TABLE RREP_REPORTS
ALTER COLUMN REP_C_CONNECTION VARCHAR(400)
GO

ALTER TABLE RREP_REPORTS
ALTER COLUMN REP_C_LISTAEDICAO VARCHAR(200)
GO

ALTER TABLE RREP_REPORTS
ALTER COLUMN REP_C_LISTAEXCLUSAO VARCHAR(200)
GO

ALTER TABLE RREP_REPORTS
ALTER COLUMN REP_C_CONNECTION VARCHAR(300)
GO

ALTER TABLE RREP_REPORTS
ALTER COLUMN REP_C_CAMPOAGRUPAMENTO VARCHAR(300)
GO

--###########################################################################################################
IF OBJECT_ID('RCAM_CAMPOS') IS NULL
	CREATE TABLE RCAM_CAMPOS (
		CAM_N_CODIGO int IDENTITY (1, 1) NOT NULL ,
		CAM_N_REP_N_CODIGO int NOT NULL ,
		CAM_C_ALIAS nvarchar (50)  NULL ,
		CAM_C_ACESSO varchar (10)  NULL ,
		CAM_N_POSICAO int NOT NULL ,
		CAM_N_WIDTH int NOT NULL ,
		CAM_C_APELIDO varchar (30)  NULL ,
		CAM_N_SEARCH_RANGE smallint NOT NULL ,
		CAM_N_SEARCH_BUSCA smallint NOT NULL ,
		CAM_N_SEARCH_FILTRO smallint NOT NULL ,
		CAM_N_VISIBLE smallint NOT NULL ,
		CAM_N_ORDEM int NULL,
		CONSTRAINT PK_RCAM PRIMARY KEY (CAM_N_CODIGO)
	)
GO


--###########################################################################################################
IF OBJECT_ID('RFIL_FILTROS') IS NULL
	CREATE TABLE RFIL_FILTROS (
		FIL_N_CODIGO int IDENTITY (1, 1) NOT NULL ,
		FIL_C_CAM_C_ALIAS nvarchar (50)  NOT NULL ,
		FIL_N_REP_N_CODIGO int NOT NULL ,
		FIL_C_OPERACAO char (2)  NOT NULL ,
		FIL_C_VALOR_COMPARACAO varchar (100)  NOT NULL ,
		FIL_C_TIPO_COMPARACAO char (10)  NOT NULL,
		CONSTRAINT PK_RFIL PRIMARY KEY (FIL_N_CODIGO)
	)
GO

--###########################################################################################################
IF OBJECT_ID('RFIP_FILTROS_PROCEDURE') IS NULL
	CREATE TABLE RFIP_FILTROS_PROCEDURE (
		FIP_N_ID INT IDENTITY,
		FIP_N_MOI_N_CODIGO int NOT NULL,
		FIP_C_PARAMETRO varchar(50) NOT NULL,
		FIP_C_PARAMETRO_VALOR varchar(100) NOT NULL,
		FIP_C_PARAMETRO_TIPO varchar(50) NOT NULL,
		FIP_C_TITULO varchar(50) NOT NULL,
		FIP_B_FILTRO bit NOT NULL,
		FIP_B_NULO bit NOT NULL,
		CONSTRAINT PK_RFIP PRIMARY KEY (FIP_N_ID)
	)
GO

--#####################################################################################################################
--***** CONSTRAINTS ***************************************************************************************************
--#####################################################################################################################
IF OBJECT_ID('PK_FFOR_FORMULARIO') IS NULL
	ALTER TABLE [FFOR_FORMULARIO] WITH NOCHECK ADD 
		CONSTRAINT [PK_FFOR_FORMULARIO] PRIMARY KEY  CLUSTERED ([FOR_N_CODIGO])   
GO

IF OBJECT_ID('DF_FFOR_FORMULARIO_FOR_B_SYSTEMFORM') IS NULL
	ALTER TABLE [FFOR_FORMULARIO] WITH NOCHECK ADD 
		CONSTRAINT [DF_FFOR_FORMULARIO_FOR_B_SYSTEMFORM] DEFAULT (0) FOR [FOR_B_SYSTEMFORM]
GO

--#####################################################################################################################
--***** ALTER TABLES **************************************************************************************************
--#####################################################################################################################
if not exists(select * from syscolumns where id = object_id('RREP_REPORTS') and name = 'REP_C_TITULOGRAFICO')
	ALTER TABLE RREP_REPORTS ADD REP_C_TITULOGRAFICO	nvarchar (100)  NULL ,
								 REP_N_VISUALIZACAOGRAFICO INT NULL ,
								 REP_N_LARGURAGRAFICO INT NULL , 
								 REP_N_ALTURAGRAFICO INT NULL,
								 REP_B_MOSTRARVALORESGRAFICO BIT NULL ,
								 REP_C_CAMPONOMEGRAFICO VARCHAR(200) NULL ,
								 REP_C_CAMPOVALORGRAFICO VARCHAR(200) NULL ,
								 REP_C_POSICAOLEGENDAGRAFICO INT NULL ,
								 REP_C_FUNCAOAGRUPAMENTOGRAFICO INT NULL , 
								 REP_C_CAMPOAGRUPAMENTO VARCHAR(100) NULL,
								 REP_B_VISUALIZAGRAFICO BIT NOT NULL DEFAULT 'FALSE'
	
GO

if not exists(select * from syscolumns where id = object_id('RREP_REPORTS') and name = 'REP_B_VISUALIZAGRAFICO')
	ALTER TABLE RREP_REPORTS ADD REP_B_VISUALIZAGRAFICO BIT NOT NULL DEFAULT 'FALSE'
GO

IF NOT OBJECT_ID('FFXW_FORMULARIO_WORKFLOW') IS NULL
	ALTER TABLE FFXW_FORMULARIO_WORKFLOW ALTER COLUMN [FXW_C_DIV] [varchar] (4000) NULL
GO

IF NOT OBJECT_ID('FFXW_FORMULARIO_WORKFLOW') IS NULL
	ALTER TABLE FFXW_FORMULARIO_WORKFLOW ALTER COLUMN [FXW_C_DIVEDIT] [varchar] (4000) NULL
GO

IF NOT OBJECT_ID('DF_FFOR_FORMULARIO_FOR_N_VINCULA_USUARIO') IS NULL
	ALTER TABLE FFOR_FORMULARIO DROP CONSTRAINT DF_FFOR_FORMULARIO_FOR_N_VINCULA_USUARIO
GO

IF EXISTS (SELECT 1 FROM SYS.COLUMNS WHERE NAME = 'FOR_N_VINCULA_USUARIO' AND OBJECT_ID = OBJECT_ID('FFOR_FORMULARIO'))
	ALTER TABLE FFOR_FORMULARIO DROP COLUMN FOR_N_VINCULA_USUARIO
GO

IF NOT EXISTS (SELECT 1 FROM SYS.COLUMNS WHERE NAME = 'FOR_D_PUBLICACAO' AND OBJECT_ID = OBJECT_ID('FFOR_FORMULARIO'))
BEGIN
	ALTER TABLE FFOR_FORMULARIO ADD  FOR_D_PUBLICACAO DATETIME NULL
	ALTER TABLE FFOR_FORMULARIO ADD  FOR_N_USU_PUBLICADOR INT NULL
END
GO

IF NOT EXISTS (SELECT 1 FROM SYS.COLUMNS WHERE NAME = 'FXI_ISP_N_ID' AND OBJECT_ID = OBJECT_ID('FFXI_FORMULARIO_ITEM_PROCESSO'))
BEGIN
	ALTER TABLE FFXI_FORMULARIO_ITEM_PROCESSO ADD FXI_ISP_N_ID INT
END
GO

IF EXISTS (SELECT 1 FROM SYS.COLUMNS WHERE NAME = 'FOR_C_APELIDO' AND OBJECT_ID = OBJECT_ID('FFOR_FORMULARIO') AND COL_LENGTH('FFOR_FORMULARIO', 'FOR_C_APELIDO')<=30)
BEGIN
	ALTER TABLE [FFOR_FORMULARIO] ALTER COLUMN [FOR_C_APELIDO] VARCHAR(100) NOT NULL
END
GO

IF EXISTS (SELECT 1 FROM SYS.COLUMNS WHERE NAME = 'FOR_C_TITULO' AND OBJECT_ID = OBJECT_ID('FFOR_FORMULARIO') AND COL_LENGTH('FFOR_FORMULARIO', 'FOR_C_TITULO')<60)
BEGIN
	ALTER TABLE [FFOR_FORMULARIO] ALTER COLUMN [FOR_C_TITULO] VARCHAR(60) NOT NULL
END
GO

IF NOT EXISTS (SELECT 1 FROM SYS.COLUMNS WHERE NAME = 'FOR_C_LAYOUT' AND OBJECT_ID = OBJECT_ID('FFOR_FORMULARIO'))
BEGIN
	ALTER TABLE FFOR_FORMULARIO ADD  [FOR_C_LAYOUT] VARCHAR(MAX) NULL
	ALTER TABLE FFOR_FORMULARIO ADD  [FOR_C_DATASOURCES] VARCHAR(MAX) NULL
	ALTER TABLE FFOR_FORMULARIO ADD  [FOR_C_CONFIGURATION] VARCHAR(MAX) NULL
	ALTER TABLE FFOR_FORMULARIO ADD  [FOR_C_EXECCONFIG] VARCHAR(MAX) NULL
	ALTER TABLE FFOR_FORMULARIO ADD  [FOR_D_EDICAO] DATETIME NULL
END
GO

IF NOT EXISTS (SELECT 1 FROM SYS.COLUMNS WHERE NAME = 'FOR_B_USEWORKFLOW' AND OBJECT_ID = OBJECT_ID('FFOR_FORMULARIO'))
BEGIN
	ALTER TABLE FFOR_FORMULARIO ADD  [FOR_B_USEWORKFLOW] [bit] NULL
END
GO

IF OBJECT_ID('DF_FFOR_FORMULARIO_FOR_B_USEWORKFLOW') IS NULL
	ALTER TABLE [FFOR_FORMULARIO] WITH NOCHECK ADD 
		CONSTRAINT DF_FFOR_FORMULARIO_FOR_B_USEWORKFLOW DEFAULT (0) FOR [FOR_B_USEWORKFLOW]
GO

IF NOT EXISTS (SELECT 1 FROM SYS.COLUMNS WHERE NAME = 'FOR_N_USU_EDITOR' AND OBJECT_ID = OBJECT_ID('FFOR_FORMULARIO'))
BEGIN
	ALTER TABLE FFOR_FORMULARIO ADD [FOR_N_USU_EDITOR] INT NULL
END
GO

IF NOT EXISTS (SELECT 1 FROM SYS.COLUMNS WHERE NAME = 'PFR_C_GRIDCONTROLUI' AND OBJECT_ID = OBJECT_ID('FPFR_PUBLISHED_FORM'))
BEGIN
	ALTER TABLE FPFR_PUBLISHED_FORM ADD [PFR_C_GRIDCONTROLUI] VARCHAR(MAX) NULL
END
GO

--#####################################################################################################################
--***** PROCEDURES FORMS **********************************************************************************************
--#####################################################################################################################
IF OBJECT_ID('frm_ListAllAreas') IS NULL
	EXEC('CREATE PROCEDURE frm_ListAllAreas AS BEGIN	SELECT 1 END')
GO

ALTER PROCEDURE frm_ListAllAreas
(
	@IN_N_PORTALID INT
)	
AS
	SELECT ARE_N_ID FROM WPARE_AREA WHERE ARE_N_POR_N_ID = 0 OR ARE_N_POR_N_ID = -1
GO






--#####################################################################################################################
IF OBJECT_ID('frm_DelCampoTabela') IS NULL
	EXEC('CREATE PROCEDURE frm_DelCampoTabela AS BEGIN	SELECT 1 END')
GO

ALTER PROCEDURE frm_DelCampoTabela 
(
	@IN_NOMECAMPO VARCHAR(30),
	@IN_NOMETABELA VARCHAR(30)
)
AS
	DECLARE @SQL NVARCHAR(500)
	SET @SQL = 'ALTER TABLE ' + @IN_NOMETABELA + ' DROP CONSTRAINT ' + (SELECT SYSOBJECTS.NAME FROM SYSCOLUMNS INNER JOIN SYSOBJECTS ON SYSCOLUMNS.CDEFAULT = SYSOBJECTS.ID 
				WHERE 
				SYSCOLUMNS.ID = (SELECT ID FROM SYSOBJECTS WHERE NAME = @IN_NOMETABELA) AND SYSCOLUMNS.NAME = @IN_NOMECAMPO)
	SET @SQL = @SQL + ' ALTER TABLE ' + @IN_NOMETABELA + ' DROP COLUMN ' + @IN_NOMECAMPO
	EXECUTE sp_ExecuteSQL @SQL
GO


--#####################################################################################################################
IF OBJECT_ID('frm_DropTable') IS NULL
	EXEC('CREATE PROCEDURE frm_DropTable AS BEGIN	SELECT 1 END')
GO

ALTER PROCEDURE frm_DropTable
(
	@IN_C_APELIDO	NVARCHAR(30)
)
AS
	DECLARE @SQL	NVARCHAR(200)
	SET @SQL =  'DROP TABLE ' +  @IN_C_APELIDO
	EXECUTE sp_executeSQL @SQL

GO

--#####################################################################################################################
IF OBJECT_ID('frm_ExisteApelido') IS NULL
	EXEC('CREATE PROCEDURE frm_ExisteApelido AS BEGIN	SELECT 1 END')
GO

ALTER PROCEDURE frm_ExisteApelido
(
	@IN_C_APELIDO	VARCHAR(100)
)
AS
IF OBJECT_ID(@IN_C_APELIDO) IS NOT NULL
	SELECT 1 AS FOUND
	ELSE
	SELECT 0 AS FOUND
GO

--#####################################################################################################################
IF OBJECT_ID('frm_ExisteTabela') IS NULL
	EXEC('CREATE PROCEDURE frm_ExisteTabela AS BEGIN	SELECT 1 END')
GO

ALTER PROCEDURE frm_ExisteTabela
(
	@IN_C_APELIDO	VARCHAR(100)
)
AS
IF OBJECT_ID(@IN_C_APELIDO, 'U') IS NOT NULL
	SELECT 1 AS FOUND
	ELSE
	SELECT 0 AS FOUND
GO
--#####################################################################################################################
IF OBJECT_ID('frm_ExisteCampo') IS NULL
	EXEC('CREATE PROCEDURE frm_ExisteCampo AS BEGIN	SELECT 1 END')
GO

ALTER PROCEDURE frm_ExisteCampo (
	@IN_C_APELIDO	NVARCHAR(100),
	@IN_C_COLUNA	NVARCHAR(100)
)
 AS
SELECT COUNT(SYSCOLUMNS.NAME) AS FOUND FROM SYSCOLUMNS
	INNER JOIN SYSOBJECTS
	ON SYSCOLUMNS.ID = SYSOBJECTS.ID
	WHERE SYSCOLUMNS.NAME = @IN_C_COLUNA
	AND SYSOBJECTS.NAME = @IN_C_APELIDO
	AND SYSOBJECTS.TYPE = 'U'
GO

IF OBJECT_ID('frm_ListCampos') IS NULL
	EXEC('CREATE PROCEDURE frm_ListCampos AS BEGIN	SELECT 1 END')
GO

ALTER PROCEDURE frm_ListCampos (
	@IN_C_APELIDO	NVARCHAR(100)
)
 AS
SELECT 
	COLUMN_NAME AS COLUMNNAME, 
	DATA_TYPE AS DBTYPE,
	CHARACTER_MAXIMUM_LENGTH AS SIZE,
	NUMERIC_SCALE AS [PRECISION]
	FROM INFORMATION_SCHEMA.COLUMNS 
	WHERE TABLE_NAME = @IN_C_APELIDO
GO

--#####################################################################################################################
IF OBJECT_ID('frm_GetCodigoByUser') IS NULL
	EXEC('CREATE PROCEDURE frm_GetCodigoByUser AS BEGIN	SELECT 1 END')
GO

ALTER PROCEDURE  frm_GetCodigoByUser
(
	@IN_N_USU_N_CODIGO int,
	@IN_C_FORM_APELIDO VARCHAR(30)
)
AS
	DECLARE @SQL NVARCHAR(500)
	SET @SQL = ' SELECT CodigoAutomatico, GUID FROM ' + @IN_C_FORM_APELIDO + 
			   '  WHERE CodigoUsuario = ' + CONVERT(VARCHAR, @IN_N_USU_N_CODIGO)
	EXECUTE sp_executeSQL @SQL

GO

--#####################################################################################################################
IF OBJECT_ID('frm_ListParametrosProcedure') IS NULL
	EXEC('CREATE PROCEDURE frm_ListParametrosProcedure AS BEGIN	SELECT 1 END')
GO

ALTER PROCEDURE frm_ListParametrosProcedure
	@objname nvarchar(776) = NULL  -- object name we're after
AS
 -- PRELIMINARY
 set nocount on
 declare @dbname sysname
 
 -- OBTAIN DISPLAY STRINGS FROM spt_values UP FRONT --
 declare @no varchar(35), @yes varchar(35), @none varchar(35)
 set @no = 'no'--name from master.spt_values where type = 'B' and number = 0
 set @yes = 'yes' --name from master.spt_values where type = 'B' and number = 1
 set @none = 'none'--name from master.spt_values where type = 'B' and number = 2
 
 -- Make sure the @objname is local to the current database.
 select @dbname = parsename(@objname,3)
 
 if @dbname is not null and @dbname <> db_name()
  begin
   raiserror(15250,-1,-1)
   return(1)
  end
 
 -- @objname must be either sysobjects or systypes: first look in sysobjects
 declare @objid int
 declare @sysobj_type char(2)
 select @objid = id, @sysobj_type = xtype from sysobjects where id = object_id(@objname)
 
 -- IF NOT IN SYSOBJECTS, TRY SYSTYPES --
 if @objid is null
 begin
  -- UNDONE: SHOULD CHECK FOR AND DISALLOW MULTI-PART NAME
  select @objid = xusertype from systypes where name = @objname
 
  -- IF NOT IN SYSTYPES, GIVE UP
  if @objid is null
  begin
   select @dbname=db_name()
   raiserror(15009,-1,-1,@objname,@dbname)
   return(1)
  end
 
  -- DATA TYPE HELP (prec/scale only valid for numerics)
  select
   Type_name  = name,
   Storage_type = type_name(xtype),
   Length  = length,
   Prec   = TypeProperty(name, 'precision'),
   Scale   = TypeProperty(name, 'scale'),
   Nullable  = case when allownulls=1 then @yes else @no end,
   Default_name = isnull(object_name(tdefault), @none),
   Rule_name  = isnull(object_name(domain), @none),
   Collation  = collation
  from systypes
  where xusertype = @objid
 
  return(0)
 end
 
 -- DISPLAY COLUMN IF TABLE / VIEW
 if @sysobj_type in ('S ','U ','V ','TF','IF')
 begin
 
  -- SET UP NUMERIC TYPES: THESE WILL HAVE NON-BLANK PREC/SCALE
  declare @numtypes nvarchar(80)
  select @numtypes = N'tinyint,smallint,decimal,int,real,money,float,numeric,smallmoney'
 
  select
   Column_name   = name,
   Type     = type_name(xusertype),
   Length    = convert(int, length),
   Prec     = case when charindex(type_name(xtype), @numtypes) > 0
		  then convert(char(5),ColumnProperty(id, name, 'precision'))
		  else '     ' end,
   Scale     = case when charindex(type_name(xtype), @numtypes) > 0
		 then convert(char(5),OdbcScale(xtype,xscale))
		 else '     ' end,
   Nullable    = case when isnullable = 0 then @no else @yes end,
   Collation  = collation
  from syscolumns where id = @objid and number = 0 order by colid
 
  -- IDENTITY COLUMN?
  if @sysobj_type in ('S ','U ','V ','TF')
  begin
   declare @colname sysname
   select @colname = name from syscolumns where id = @objid
	  and colstat & 1 = 1
   select
	[Identity]    = isnull(@colname,'No identity column defined.'),
	Seed     = ident_seed(@objname),
	Increment    = ident_incr(@objname),
	Not_For_Replication = ColumnProperty(@objid, @colname, 'IsIDNotForRepl')
   -- ROWGUIDCOL?
   select @colname = null
   select @colname = name from syscolumns where id = @objid and number = 0
	  and ColumnProperty(@objid, name, 'IsRowGuidCol') = 1
   select [RowGuidCol] = isnull(@colname,'No rowguidcol column defined.')
  end
 end
 
 -- DISPLAY PROC PARAMS
 if @sysobj_type in ('P ') --RF too?
 begin
  -- ANY PARAMS FOR THIS PROC?
  if exists (select id from syscolumns where id = @objid)
  begin
   -- INFO ON PROC PARAMS
   select
	Parameter_name = name,
	[Type]    = type_name(xusertype),
	[Length]   = length,
	Prec    = case when type_name(xtype) = 'uniqueidentifier' then xprec
				   else OdbcPrec(xtype, length, xprec) end,
	Scale    = OdbcScale(xtype,xscale),
	Param_order  = colid,
	Collation  = collation
 
   from syscolumns where id = @objid
  end
 end
 
 -- DISPLAY TABLE INDEXES & CONSTRAINTS
 if @sysobj_type in ('S ','U ')
 begin
  execute sp_objectfilegroup @objid
  execute sp_helpindex @objname
  execute sp_helpconstraint @objname,'nomsg'
  if (select count(*) from sysdepends where depid = @objid and deptype = 1) = 0
  begin
   raiserror(15647,-1,-1) -- 'No views with schemabinding reference this table.'
  end
  else
  begin
			select distinct [Table is referenced by views] = obj.name from sysobjects obj, sysdepends deps
	where obj.xtype ='V' and obj.id = deps.id and deps.depid = @objid
	 and deps.deptype = 1 group by obj.name
 
  end
 end
 else if @sysobj_type in ('V ')
 begin
  -- VIEWS DONT HAVE CONSTRAINTS, BUT PRINT THESE MESSAGES BECAUSE 6.5 DID
  raiserror(15469,-1,-1) -- No constraints defined
  raiserror(15470,-1,-1) --'No foreign keys reference this table.'
  execute sp_helpindex @objname
 end
 
 return (0) -- sp_help

GO

--#####################################################################################################################
IF OBJECT_ID('frm_ListFormItemProcesso') IS NULL
	EXEC('CREATE PROCEDURE frm_ListFormItemProcesso AS BEGIN	SELECT 1 END')
GO

ALTER PROCEDURE frm_ListFormItemProcesso
(
 @IN_FXI_N_ITE_N_CODIGO  int = null,
 @IN_FXI_N_FOR_N_CODAUTOMATICO int = null,
 @IN_FXI_C_FOR_C_APELIDO  varchar(100)= null,
 @IN_FXI_C_FOR_C_GUID varchar(36) = null,
 @IN_FXI_ISP_N_ID INT = NULL
)
AS
	DECLARE @SQL	VARCHAR(8000)
	DECLARE @AND	VARCHAR(10)
	BEGIN
		SELECT 
				FXI_N_ITE_N_CODIGO,
				FXI_N_FOR_N_CODAUTOMATICO,
				FXI_C_FOR_C_APELIDO,
				FXI_C_FOR_C_GUID,
				FXI_ISP_N_ID
		FROM 
				FFXI_FORMULARIO_ITEM_PROCESSO 
		WHERE
			(@IN_FXI_N_ITE_N_CODIGO IS NULL OR (@IN_FXI_N_ITE_N_CODIGO > 0 AND FXI_N_ITE_N_CODIGO = @IN_FXI_N_ITE_N_CODIGO)) AND
			(@IN_FXI_C_FOR_C_GUID IS NULL OR (@IN_FXI_C_FOR_C_GUID <> '' AND UPPER(FXI_C_FOR_C_GUID) LIKE UPPER(@IN_FXI_C_FOR_C_GUID))) AND
			(@IN_FXI_N_FOR_N_CODAUTOMATICO IS NULL OR (@IN_FXI_N_FOR_N_CODAUTOMATICO > 0 AND FXI_N_FOR_N_CODAUTOMATICO = @IN_FXI_N_FOR_N_CODAUTOMATICO)) AND 
			(@IN_FXI_C_FOR_C_APELIDO IS NULL OR (@IN_FXI_C_FOR_C_APELIDO <> '' AND UPPER(FXI_C_FOR_C_APELIDO) = UPPER(@IN_FXI_C_FOR_C_APELIDO))) AND
			(@IN_FXI_ISP_N_ID IS NULL OR (@IN_FXI_ISP_N_ID > 0 AND FXI_ISP_N_ID = @IN_FXI_ISP_N_ID))
	END
GO

--#####################################################################################################################
IF OBJECT_ID('frm_AddFormItemProcesso') IS NULL
	EXEC('CREATE PROCEDURE frm_AddFormItemProcesso AS BEGIN	SELECT 1 END')
GO

ALTER PROCEDURE frm_AddFormItemProcesso
(
	@IN_FXI_N_ITE_N_CODIGO int,
	@IN_FXI_N_FOR_N_CODAUTOMATICO int,
	@IN_FXI_C_FOR_C_APELIDO varchar(100),
	@IN_FXI_C_FOR_C_GUID varchar(36),
	@IN_FXI_ISP_N_ID INT
)
AS
	BEGIN
	 IF NOT EXISTS (SELECT FXI_N_ITE_N_CODIGO FROM FFXI_FORMULARIO_ITEM_PROCESSO
					WHERE 
					FXI_N_ITE_N_CODIGO = @IN_FXI_N_ITE_N_CODIGO AND
					FXI_N_FOR_N_CODAUTOMATICO = @IN_FXI_N_FOR_N_CODAUTOMATICO AND
					ISNULL(FXI_ISP_N_ID,0) = ISNULL(@IN_FXI_ISP_N_ID,0) AND
					LTRIM(RTRIM(UPPER(FXI_C_FOR_C_APELIDO))) = LTRIM(RTRIM(UPPER(@IN_FXI_C_FOR_C_APELIDO))))
			INSERT INTO FFXI_FORMULARIO_ITEM_PROCESSO
			(
				FXI_N_ITE_N_CODIGO,
				FXI_N_FOR_N_CODAUTOMATICO,
				FXI_C_FOR_C_APELIDO,
				FXI_C_FOR_C_GUID,
				FXI_ISP_N_ID
			) VALUES (
				@IN_FXI_N_ITE_N_CODIGO,
				@IN_FXI_N_FOR_N_CODAUTOMATICO,
				@IN_FXI_C_FOR_C_APELIDO,
				@IN_FXI_C_FOR_C_GUID,
				@IN_FXI_ISP_N_ID
			)
	END
GO

--#####################################################################################################################
IF OBJECT_ID('FRM_LISTCHILDITEMS') IS NULL
	EXEC('CREATE PROCEDURE FRM_LISTCHILDITEMS AS BEGIN	SELECT 1 END')
GO

ALTER PROCEDURE [FRM_LISTCHILDITEMS](
	@FORMALIAS AS NVARCHAR(50),
	@PARENTGUID AS NVARCHAR(40)
)
AS
	BEGIN
		DECLARE @SQL NVARCHAR(4000)
		SET @SQL = 'SELECT * FROM ' + @FORMALIAS + ' WHERE PARENTGUID = ''' + @PARENTGUID + ''''
		EXEC (@SQL)
	END
GO

--#####################################################################################################################
IF OBJECT_ID('frm_GetItemIdbyGUID') IS NULL
	EXEC('CREATE PROCEDURE frm_GetItemIdbyGUID AS BEGIN	SELECT 1 END')
GO

ALTER PROCEDURE frm_GetItemIdbyGUID(
	@FORMALIAS AS NVARCHAR(50),
	@ITEMGUID AS NVARCHAR(40)
)
AS
	BEGIN
		DECLARE @SQL NVARCHAR(4000)
		SET @SQL = 'SELECT CodigoAutomatico FROM ' + @FORMALIAS + ' WHERE GUID = ''' + @ITEMGUID + ''''
		EXEC (@SQL)
	END
GO


--#####################################################################################################################
--***** PROCEDURES REPORTS ********************************************************************************************
--#####################################################################################################################
IF OBJECT_ID('rep_AddFiltros') IS NULL
	EXEC('CREATE PROCEDURE rep_AddFiltros AS BEGIN	SELECT 1 END')
GO
ALTER PROCEDURE rep_AddFiltros (
	@IN_FIL_C_CAM_ALIAS   NVARCHAR(50),
	@IN_FIL_N_REP_N_CODIGO    int,
	@IN_FIL_C_OPERACAO    char(2),
	@IN_FIL_C_VALOR_COMPARACAO    varchar(100),
	@IN_FIL_C_TIPO_COMPARACAO    char(2)
) AS
BEGIN
	SET NOCOUNT ON
	INSERT INTO RFIL_FILTROS
	(
		FIL_C_CAM_C_ALIAS,
		FIL_N_REP_N_CODIGO,
		FIL_C_OPERACAO,
		FIL_C_VALOR_COMPARACAO,
		FIL_C_TIPO_COMPARACAO
	) VALUES (
		@IN_FIL_C_CAM_ALIAS,
		@IN_FIL_N_REP_N_CODIGO,
		@IN_FIL_C_OPERACAO,
		@IN_FIL_C_VALOR_COMPARACAO,
		@IN_FIL_C_TIPO_COMPARACAO)
	SET NOCOUNT OFF
	SELECT @@IDENTITY
END
GO

--###########################################################################################################
IF OBJECT_ID('rep_AtualizaCampos') IS NULL
	EXEC('CREATE PROCEDURE rep_AtualizaCampos AS BEGIN	SELECT 1 END')
GO
ALTER PROCEDURE rep_AtualizaCampos (
	@IN_FOR_ID INT,
	@IN_CAM_N_REP_N_CODIGO    int,
	@IN_CAM_C_ALIAS    nvarchar(100),
	@IN_CAM_C_ACESSO    varchar(10),
	@IN_CAM_N_POSICAO    int,
	@IN_CAM_N_WIDTH    int,
	@IN_CAM_C_APELIDO    varchar(30),
	@IN_CAM_N_SEARCH_RANGE    smallint,
	@IN_CAM_N_SEARCH_BUSCA    smallint,
	@IN_CAM_N_SEARCH_FILTRO    smallint,
	@IN_CAM_N_VISIBLE    smallint,
	@IN_CAM_N_ORDEM    int
) AS
BEGIN
	DECLARE @CAM_ID INT

	SELECT	@CAM_ID = CAM_N_CODIGO 
	FROM	RCAM_CAMPOS 
	INNER JOIN RREP_REPORTS ON REP_N_MOI_N_CODIGO = CAM_N_REP_N_CODIGO
	WHERE 
		CAM_N_REP_N_CODIGO = @IN_CAM_N_REP_N_CODIGO AND
		REP_N_FOR_N_CODIGO = @IN_FOR_ID AND
		CAM_C_ALIAS = @IN_CAM_C_ALIAS

	IF @CAM_ID IS NULL 
	BEGIN
		SET NOCOUNT ON
		INSERT INTO RCAM_CAMPOS (
			CAM_N_REP_N_CODIGO,
			CAM_C_ALIAS,
			CAM_C_ACESSO,
			CAM_N_POSICAO,
			CAM_N_WIDTH,
			CAM_C_APELIDO,
			CAM_N_SEARCH_RANGE,
			CAM_N_SEARCH_BUSCA,
			CAM_N_SEARCH_FILTRO,
			CAM_N_VISIBLE,
			CAM_N_ORDEM
		) VALUES (
			@IN_CAM_N_REP_N_CODIGO,
			@IN_CAM_C_ALIAS,
			@IN_CAM_C_ACESSO,
			@IN_CAM_N_POSICAO,
			@IN_CAM_N_WIDTH,
			@IN_CAM_C_APELIDO,
			@IN_CAM_N_SEARCH_RANGE,
			@IN_CAM_N_SEARCH_BUSCA,
			@IN_CAM_N_SEARCH_FILTRO,
			@IN_CAM_N_VISIBLE,
			@IN_CAM_N_ORDEM)
		SET NOCOUNT OFF
		SELECT @@IDENTITY
	END
	ELSE
	BEGIN
		UPDATE RCAM_CAMPOS SET
			CAM_N_REP_N_CODIGO = @IN_CAM_N_REP_N_CODIGO,
			CAM_C_ALIAS = @IN_CAM_C_ALIAS,
			CAM_C_ACESSO = @IN_CAM_C_ACESSO,
			CAM_N_POSICAO=  @IN_CAM_N_POSICAO,
			CAM_N_WIDTH = @IN_CAM_N_WIDTH,
			CAM_C_APELIDO = @IN_CAM_C_APELIDO,
			CAM_N_SEARCH_RANGE = @IN_CAM_N_SEARCH_RANGE,
			CAM_N_SEARCH_BUSCA = @IN_CAM_N_SEARCH_BUSCA,
			CAM_N_SEARCH_FILTRO = @IN_CAM_N_SEARCH_FILTRO,
			CAM_N_VISIBLE = @IN_CAM_N_VISIBLE,
			CAM_N_ORDEM = @IN_CAM_N_ORDEM
		WHERE CAM_N_CODIGO = @CAM_ID
	END
END
GO

--###########################################################################################################
IF OBJECT_ID('rep_AtualizaCamposProc') IS NULL
	EXEC('CREATE PROCEDURE rep_AtualizaCamposProc AS BEGIN	SELECT 1 END')
GO
ALTER PROCEDURE rep_AtualizaCamposProc (
	@IN_CAM_N_REP_N_CODIGO    int,
	@IN_CAM_C_ALIAS    nvarchar(100),
	@IN_CAM_C_ACESSO    varchar(10),
	@IN_CAM_N_POSICAO    int,
	@IN_CAM_N_WIDTH    int,
	@IN_CAM_C_APELIDO    varchar(30),
	@IN_CAM_N_SEARCH_RANGE    smallint,
	@IN_CAM_N_SEARCH_BUSCA    smallint,
	@IN_CAM_N_SEARCH_FILTRO    smallint,
	@IN_CAM_N_VISIBLE    smallint,
	@IN_CAM_N_ORDEM    int
) AS
BEGIN
	DECLARE @CAM_ID INT

	SELECT @CAM_ID = CAM_N_CODIGO 
	FROM   RCAM_CAMPOS 
	WHERE
		CAM_N_REP_N_CODIGO = @IN_CAM_N_REP_N_CODIGO AND
		CAM_C_ALIAS = @IN_CAM_C_ALIAS

	IF @CAM_ID IS NULL 
	BEGIN
		SET NOCOUNT ON
		INSERT INTO RCAM_CAMPOS (
			CAM_N_REP_N_CODIGO,
			CAM_C_ALIAS,
			CAM_C_ACESSO,
			CAM_N_POSICAO,
			CAM_N_WIDTH,
			CAM_C_APELIDO,
			CAM_N_SEARCH_RANGE,
			CAM_N_SEARCH_BUSCA,
			CAM_N_SEARCH_FILTRO,
			CAM_N_VISIBLE,
			CAM_N_ORDEM
		) VALUES (
			@IN_CAM_N_REP_N_CODIGO,
			@IN_CAM_C_ALIAS,
			@IN_CAM_C_ACESSO,
			@IN_CAM_N_POSICAO,
			@IN_CAM_N_WIDTH,
			@IN_CAM_C_APELIDO,
			@IN_CAM_N_SEARCH_RANGE,
			@IN_CAM_N_SEARCH_BUSCA,
			@IN_CAM_N_SEARCH_FILTRO,
			@IN_CAM_N_VISIBLE,
			@IN_CAM_N_ORDEM)
		SET NOCOUNT OFF
		SELECT @@IDENTITY
	END
	ELSE
	BEGIN
		UPDATE RCAM_CAMPOS SET
			CAM_N_REP_N_CODIGO = @IN_CAM_N_REP_N_CODIGO,
			CAM_C_ALIAS = @IN_CAM_C_ALIAS,
			CAM_C_ACESSO = @IN_CAM_C_ACESSO,
			CAM_N_POSICAO=  @IN_CAM_N_POSICAO,
			CAM_N_WIDTH = @IN_CAM_N_WIDTH,
			CAM_C_APELIDO = @IN_CAM_C_APELIDO,
			CAM_N_SEARCH_RANGE = @IN_CAM_N_SEARCH_RANGE,
			CAM_N_SEARCH_BUSCA = @IN_CAM_N_SEARCH_BUSCA,
			CAM_N_SEARCH_FILTRO = @IN_CAM_N_SEARCH_FILTRO,
			CAM_N_VISIBLE = @IN_CAM_N_VISIBLE,
			CAM_N_ORDEM = @IN_CAM_N_ORDEM
		WHERE CAM_N_CODIGO = @CAM_ID
	END
END
GO

--###########################################################################################################
IF OBJECT_ID('rep_AtualizaReports') IS NULL
	EXEC('CREATE PROCEDURE rep_AtualizaReports AS BEGIN	SELECT 1 END')
GO
ALTER PROCEDURE rep_AtualizaReports (
	@IN_REC_ID INT,
	@IN_REP_N_FOR_N_CODIGO    int,
	@IN_REP_C_TITULO    nvarchar(200),
	@IN_REP_N_PAGECOUNT    int,
	@IN_REP_N_TIPO    char(2),
	@IN_REP_C_PARAMETROS    varchar(2000),
	@IN_REP_C_PROCEDURE    varchar(200),
	@IN_REP_C_LISTAEDICAO    varchar(200),
	@IN_REP_C_LISTAEXCLUSAO    varchar(200),
	@IN_REP_C_CONNECTION    varchar(400),
	@IN_REP_C_TITULOGRAFICO nvarchar(100),
	@IN_REP_N_VISUALIZACAOG int,
	@IN_REP_N_LARGURAGRAFICO int,
	@IN_REP_N_ALTURAGRAFICO int,
	@IN_REP_B_MOSTRARVALORESG bit,
	@IN_REP_C_CAMPONOMEGRAFICO varchar(200),
	@IN_REP_C_CAMPOVALORGRAFICO varchar(200),
	@IN_REP_C_POSICAOLEGENDAG int,
	@IN_REP_C_FUNCAOAGRUPAMENTOG int,
	@IN_REP_C_CAMPOAGRUPAMENTO varchar(300),
	@IN_REP_B_VISUALIZAGRAFICO BIT
) AS
BEGIN
	DECLARE @REP_COD INT
	SET @REP_COD = 0
	SELECT @REP_COD = REP_N_MOI_N_CODIGO FROM RREP_REPORTS WHERE REP_N_MOI_N_CODIGO = @IN_REC_ID
	IF @REP_COD = 0
	BEGIN
		SET NOCOUNT ON
		INSERT INTO RREP_REPORTS (
			REP_N_MOI_N_CODIGO,	
			REP_N_FOR_N_CODIGO,
			REP_C_TITULO,
			REP_N_PAGECOUNT,
			REP_N_TIPO,
			REP_C_PARAMETROS,
			REP_C_PROCEDURE,
			REP_C_LISTAEDICAO,
			REP_C_LISTAEXCLUSAO,
			REP_C_CONNECTION,
			REP_C_TITULOGRAFICO,
			REP_N_VISUALIZACAOGRAFICO,
			REP_N_LARGURAGRAFICO,
			REP_N_ALTURAGRAFICO,
			REP_B_MOSTRARVALORESGRAFICO,
			REP_C_CAMPONOMEGRAFICO,
			REP_C_CAMPOVALORGRAFICO,
			REP_C_POSICAOLEGENDAGRAFICO,
			REP_C_FUNCAOAGRUPAMENTOGRAFICO,
			REP_C_CAMPOAGRUPAMENTO,
			REP_B_VISUALIZAGRAFICO
		) VALUES (
			@IN_REC_ID,
			@IN_REP_N_FOR_N_CODIGO,
			@IN_REP_C_TITULO,
			@IN_REP_N_PAGECOUNT,
			@IN_REP_N_TIPO,
			@IN_REP_C_PARAMETROS,
			@IN_REP_C_PROCEDURE,
			@IN_REP_C_LISTAEDICAO,
			@IN_REP_C_LISTAEXCLUSAO,
			@IN_REP_C_CONNECTION,
			@IN_REP_C_TITULOGRAFICO,
			@IN_REP_N_VISUALIZACAOG,
			@IN_REP_N_LARGURAGRAFICO,
			@IN_REP_N_ALTURAGRAFICO,
			@IN_REP_B_MOSTRARVALORESG,
			@IN_REP_C_CAMPONOMEGRAFICO,
			@IN_REP_C_CAMPOVALORGRAFICO,
			@IN_REP_C_POSICAOLEGENDAG,
			@IN_REP_C_FUNCAOAGRUPAMENTOG,
			@IN_REP_C_CAMPOAGRUPAMENTO,
			@IN_REP_B_VISUALIZAGRAFICO)
		SET NOCOUNT OFF
		SELECT @@IDENTITY
	END
	ELSE
	BEGIN
		UPDATE RREP_REPORTS SET 
		REP_N_FOR_N_CODIGO = @IN_REP_N_FOR_N_CODIGO,
		REP_C_TITULO = @IN_REP_C_TITULO,
		REP_N_PAGECOUNT = @IN_REP_N_PAGECOUNT,
		REP_N_TIPO = @IN_REP_N_TIPO,
		REP_C_PARAMETROS = @IN_REP_C_PARAMETROS,
		REP_C_PROCEDURE = @IN_REP_C_PROCEDURE,
		REP_C_LISTAEDICAO = @IN_REP_C_LISTAEDICAO,
		REP_C_LISTAEXCLUSAO = @IN_REP_C_LISTAEXCLUSAO,
		REP_C_CONNECTION = @IN_REP_C_CONNECTION,
		REP_C_TITULOGRAFICO = @IN_REP_C_TITULOGRAFICO,
		REP_N_VISUALIZACAOGRAFICO = @IN_REP_N_VISUALIZACAOG,
		REP_N_LARGURAGRAFICO = @IN_REP_N_LARGURAGRAFICO,
		REP_N_ALTURAGRAFICO = @IN_REP_N_ALTURAGRAFICO,
		REP_B_MOSTRARVALORESGRAFICO = @IN_REP_B_MOSTRARVALORESG,
		REP_C_CAMPONOMEGRAFICO = @IN_REP_C_CAMPONOMEGRAFICO,
		REP_C_CAMPOVALORGRAFICO = @IN_REP_C_CAMPOVALORGRAFICO,
		REP_C_POSICAOLEGENDAGRAFICO = @IN_REP_C_POSICAOLEGENDAG,
		REP_C_FUNCAOAGRUPAMENTOGRAFICO = @IN_REP_C_FUNCAOAGRUPAMENTOG,
		REP_C_CAMPOAGRUPAMENTO = @IN_REP_C_CAMPOAGRUPAMENTO,
		REP_B_VISUALIZAGRAFICO = @IN_REP_B_VISUALIZAGRAFICO
		WHERE REP_N_MOI_N_CODIGO = @IN_REC_ID
		SELECT @IN_REC_ID
	END
END
GO

--###########################################################################################################
IF OBJECT_ID('rep_DelCamposReports') IS NULL
	EXEC('CREATE PROCEDURE rep_DelCamposReports AS BEGIN	SELECT 1 END')
GO
ALTER PROCEDURE rep_DelCamposReports (
	@IN_REP_N_CODIGO    int
) AS
BEGIN
	SET NOCOUNT ON

	DELETE FROM RCAM_CAMPOS
	WHERE CAM_N_REP_N_CODIGO = @IN_REP_N_CODIGO

	SET NOCOUNT OFF
END
GO

--###########################################################################################################
IF OBJECT_ID('rep_DelFiltros') IS NULL
	EXEC('CREATE PROCEDURE rep_DelFiltros AS BEGIN	SELECT 1 END')
GO
ALTER PROCEDURE rep_DelFiltros (
	@IN_FIL_N_CODIGO    int
) AS
BEGIN
	SET NOCOUNT ON

	DELETE FROM RFIL_FILTROS
	WHERE FIL_N_CODIGO = @IN_FIL_N_CODIGO

	SET NOCOUNT OFF
END
GO

--###########################################################################################################
IF OBJECT_ID('rep_DelFiltrosReport') IS NULL
	EXEC('CREATE PROCEDURE rep_DelFiltrosReport AS BEGIN	SELECT 1 END')
GO
ALTER PROCEDURE rep_DelFiltrosReport (
	@IN_REP_N_CODIGO    int
) AS
BEGIN
	SET NOCOUNT ON

	DELETE FROM RFIL_FILTROS
	WHERE FIL_N_REP_N_CODIGO = @IN_REP_N_CODIGO

	SET NOCOUNT OFF
END
GO

--###########################################################################################################
IF OBJECT_ID('rep_DelRegistroForm') IS NULL
	EXEC('CREATE PROCEDURE rep_DelRegistroForm AS BEGIN	SELECT 1 END')
GO
ALTER PROCEDURE rep_DelRegistroForm (
	@IN_DATABASE NVARCHAR(30),
	@IN_TABELA NVARCHAR(30),
	@IN_COD_AUTO NVARCHAR(30),
	@COD_ID INT
) AS
BEGIN
	DECLARE @SQL NVARCHAR(500)
	SET @SQL = 'DELETE FROM [' + @IN_DATABASE + '].[' + @IN_TABELA + ']  WHERE ' + @IN_COD_AUTO + '  =  '  + CONVERT(VARCHAR, @COD_ID)
	EXECUTE sp_executesql @SQL
END
GO

--###########################################################################################################
IF OBJECT_ID('rep_GetCampos') IS NULL
	EXEC('CREATE PROCEDURE rep_GetCampos AS BEGIN	SELECT 1 END')
GO
ALTER PROCEDURE rep_GetCampos (
	@IN_CAM_N_REP_N_CODIGO    int ,
	@IN_FOR_ID    int ,
	@IN_ALIAS nvarchar(50) ,	
	@OUT_CAM_N_CODIGO    int OUTPUT,
	@OUT_CAM_C_ALIAS    nvarchar(100) OUTPUT ,
	@OUT_CAM_C_ACESSO    varchar(10) OUTPUT ,
	@OUT_CAM_N_POSICAO    int OUTPUT ,
	@OUT_CAM_N_WIDTH    int OUTPUT ,
	@OUT_CAM_C_APELIDO    varchar(30) OUTPUT ,
	@OUT_CAM_N_SEARCH_RANGE    smallint OUTPUT ,
	@OUT_CAM_N_SEARCH_BUSCA    smallint OUTPUT ,
	@OUT_CAM_N_SEARCH_FILTRO    smallint OUTPUT ,
	@OUT_CAM_N_VISIBLE    smallint OUTPUT,
	@OUT_CAM_N_ORDEM    int OUTPUT
) AS
BEGIN
	SET NOCOUNT ON
	SELECT 
		@OUT_CAM_N_CODIGO = CAM_N_CODIGO,
		@OUT_CAM_C_ALIAS = CAM_C_ALIAS,
		@OUT_CAM_C_ACESSO = CAM_C_ACESSO,
		@OUT_CAM_N_POSICAO = CAM_N_POSICAO,
		@OUT_CAM_N_WIDTH = CAM_N_WIDTH,
		@OUT_CAM_C_APELIDO = CAM_C_APELIDO,
		@OUT_CAM_N_SEARCH_RANGE = CAM_N_SEARCH_RANGE,
		@OUT_CAM_N_SEARCH_BUSCA = CAM_N_SEARCH_BUSCA,
		@OUT_CAM_N_SEARCH_FILTRO = CAM_N_SEARCH_FILTRO,
		@OUT_CAM_N_VISIBLE = CAM_N_VISIBLE,
		@OUT_CAM_N_ORDEM = CAM_N_ORDEM
	FROM RCAM_CAMPOS
	INNER JOIN RREP_REPORTS ON REP_N_MOI_N_CODIGO = CAM_N_REP_N_CODIGO
	WHERE 
		CAM_N_REP_N_CODIGO = @IN_CAM_N_REP_N_CODIGO AND
		CAM_C_ALIAS = @IN_ALIAS AND
		REP_N_FOR_N_CODIGO = @IN_FOR_ID
	SET NOCOUNT OFF
END
GO

--###########################################################################################################
IF OBJECT_ID('rep_GetCampos_Apelido') IS NULL
	EXEC('CREATE PROCEDURE rep_GetCampos_Apelido AS BEGIN	SELECT 1 END')
GO
ALTER PROCEDURE rep_GetCampos_Apelido (
	@IN_CAM_N_REP_N_CODIGO    int ,
	@IN_FOR_ID    int ,
	@IN_APELIDO  nvarchar(50) ,	
	@OUT_CAM_N_CODIGO    int OUTPUT,
	@OUT_CAM_C_ALIAS    nvarchar(100) OUTPUT ,
	@OUT_CAM_C_ACESSO    varchar(10) OUTPUT ,
	@OUT_CAM_N_POSICAO    int OUTPUT ,
	@OUT_CAM_N_WIDTH    int OUTPUT ,
	@OUT_CAM_C_APELIDO    varchar(30) OUTPUT ,
	@OUT_CAM_N_SEARCH_RANGE    smallint OUTPUT ,
	@OUT_CAM_N_SEARCH_BUSCA    smallint OUTPUT ,
	@OUT_CAM_N_SEARCH_FILTRO    smallint OUTPUT ,
	@OUT_CAM_N_VISIBLE    smallint OUTPUT,
	@OUT_CAM_N_ORDEM    int OUTPUT
) AS
BEGIN
	SET NOCOUNT ON
	SELECT 
		@OUT_CAM_N_CODIGO = CAM_N_CODIGO,
		@OUT_CAM_C_ALIAS = CAM_C_ALIAS,
		@OUT_CAM_C_ACESSO = CAM_C_ACESSO,
		@OUT_CAM_N_POSICAO = CAM_N_POSICAO,
		@OUT_CAM_N_WIDTH = CAM_N_WIDTH,
		@OUT_CAM_C_APELIDO = CAM_C_APELIDO,
		@OUT_CAM_N_SEARCH_RANGE = CAM_N_SEARCH_RANGE,
		@OUT_CAM_N_SEARCH_BUSCA = CAM_N_SEARCH_BUSCA,
		@OUT_CAM_N_SEARCH_FILTRO = CAM_N_SEARCH_FILTRO,
		@OUT_CAM_N_VISIBLE = CAM_N_VISIBLE,
		@OUT_CAM_N_ORDEM = CAM_N_ORDEM
	FROM RCAM_CAMPOS
	INNER JOIN RREP_REPORTS ON REP_N_MOI_N_CODIGO = CAM_N_REP_N_CODIGO
	WHERE 
		CAM_N_REP_N_CODIGO = @IN_CAM_N_REP_N_CODIGO AND
		CAM_C_APELIDO = @IN_APELIDO AND
		REP_N_FOR_N_CODIGO = @IN_FOR_ID
	SET NOCOUNT OFF
END
GO

--###########################################################################################################
IF OBJECT_ID('rep_GetReports') IS NULL
	EXEC('CREATE PROCEDURE rep_GetReports AS BEGIN	SELECT 1 END')
GO
ALTER PROCEDURE rep_GetReports (
	@IN_REP_N_MOI_N_CODIGO    int,
	@OUT_REP_N_FOR_N_CODIGO    int OUTPUT ,
	@OUT_REP_C_TITULO    nvarchar(200) OUTPUT ,
	@OUT_REP_N_PAGECOUNT    int OUTPUT ,
	@OUT_REP_N_TIPO   char(2)  OUTPUT ,
	@OUT_REP_C_PARAMETROS    varchar(2000) OUTPUT ,
	@OUT_REP_C_PROCEDURE    varchar(200) OUTPUT ,
	@OUT_REP_C_LISTAEDICAO    varchar(200) OUTPUT,
	@OUT_REP_C_LISTAEXCLUSAO    varchar(200) OUTPUT,
	@OUT_REP_C_CONNECTION    varchar(400) OUTPUT,
	
	@OUT_REP_C_TITULOGRAFICO nvarchar(100) OUTPUT ,
	@OUT_REP_N_VISUALIZACAOG int OUTPUT,
	@OUT_REP_N_LARGURAGRAFICO INT OUTPUT,
	@OUT_REP_N_ALTURAGRAFICO INT OUTPUT,
	@OUT_REP_B_MOSTRARVALORESG BIT OUTPUT,
	@OUT_REP_C_CAMPONOMEGRAFICO	VARCHAR(200) OUTPUT,
	@OUT_REP_C_CAMPOVALORGRAFICO VARCHAR(200) OUTPUT,
	@OUT_REP_C_POSICAOLEGENDAG	INT OUTPUT,
	@OUT_REP_C_FUNCAOAGRUPAMENTOG INT OUTPUT,
	@OUT_REP_C_CAMPOAGRUPAMENTO VARCHAR(300) OUTPUT,
	@OUT_REP_B_VISUALIZAGRAFICO BIT OUTPUT
) AS
BEGIN
	SET NOCOUNT ON
	SELECT 
		@OUT_REP_N_FOR_N_CODIGO = REP_N_FOR_N_CODIGO,
		@OUT_REP_C_TITULO = REP_C_TITULO,
		@OUT_REP_N_PAGECOUNT = REP_N_PAGECOUNT,
		@OUT_REP_N_TIPO = REP_N_TIPO,
		@OUT_REP_C_PARAMETROS = REP_C_PARAMETROS,
		@OUT_REP_C_PROCEDURE = REP_C_PROCEDURE,
		@OUT_REP_C_LISTAEDICAO = REP_C_LISTAEDICAO,
		@OUT_REP_C_LISTAEXCLUSAO = REP_C_LISTAEXCLUSAO,
		@OUT_REP_C_CONNECTION = REP_C_CONNECTION,
		@OUT_REP_C_TITULOGRAFICO = REP_C_TITULOGRAFICO,
		@OUT_REP_N_VISUALIZACAOG = REP_N_VISUALIZACAOGRAFICO,
		@OUT_REP_N_LARGURAGRAFICO = REP_N_LARGURAGRAFICO,
		@OUT_REP_N_ALTURAGRAFICO = REP_N_ALTURAGRAFICO,
		@OUT_REP_B_MOSTRARVALORESG = REP_B_MOSTRARVALORESGRAFICO,
		@OUT_REP_C_CAMPONOMEGRAFICO = REP_C_CAMPONOMEGRAFICO,
		@OUT_REP_C_CAMPOVALORGRAFICO = REP_C_CAMPOVALORGRAFICO,
		@OUT_REP_C_POSICAOLEGENDAG = REP_C_POSICAOLEGENDAGRAFICO,
		@OUT_REP_C_FUNCAOAGRUPAMENTOG = REP_C_FUNCAOAGRUPAMENTOGRAFICO,
		@OUT_REP_C_CAMPOAGRUPAMENTO = REP_C_CAMPOAGRUPAMENTO,
		@OUT_REP_B_VISUALIZAGRAFICO = REP_B_VISUALIZAGRAFICO
	FROM RREP_REPORTS
	WHERE 
		REP_N_MOI_N_CODIGO = @IN_REP_N_MOI_N_CODIGO
	SET NOCOUNT OFF
END
GO

--###########################################################################################################
IF OBJECT_ID('rep_ListCampos') IS NULL
	EXEC('CREATE PROCEDURE rep_ListCampos AS BEGIN	SELECT 1 END')
GO
ALTER PROCEDURE rep_ListCampos (
	@IN_REP_N_CODIGO INT
) AS
BEGIN
	SELECT 
		CAM_N_CODIGO,
		CAM_N_REP_N_CODIGO,
		CAM_C_ALIAS as 'Name',
		CAM_C_ACESSO,
		CAM_N_POSICAO,
		CAM_N_WIDTH,
		CAM_C_APELIDO,
		CAM_N_SEARCH_RANGE,
		CAM_N_SEARCH_BUSCA,
		CAM_N_SEARCH_FILTRO,
		CAM_N_VISIBLE,
		CAM_N_ORDEM
	FROM RCAM_CAMPOS
	WHERE CAM_N_REP_N_CODIGO = @IN_REP_N_CODIGO
	ORDER BY CAM_N_ORDEM
END
GO

--###########################################################################################################
IF OBJECT_ID('rep_ListFiltro') IS NULL
	EXEC('CREATE PROCEDURE rep_ListFiltro AS BEGIN	SELECT 1 END')
GO
ALTER PROCEDURE rep_ListFiltro (
	@IN_RELATORIOID INT
) AS
BEGIN
	SELECT
		FIL_N_CODIGO, 
		FIL_C_CAM_C_ALIAS,
		FIL_C_OPERACAO,
		FIL_C_VALOR_COMPARACAO,
		FIL_C_TIPO_COMPARACAO
	
	FROM RFIL_FILTROS
	WHERE Fil_N_REP_N_CODIGO = @IN_RELATORIOID
END
GO

--###########################################################################################################
IF OBJECT_ID('rep_UpdOrdemCampoRelatorio') IS NULL
	EXEC('CREATE PROCEDURE rep_UpdOrdemCampoRelatorio AS BEGIN	SELECT 1 END')
GO
ALTER PROCEDURE rep_UpdOrdemCampoRelatorio (
	@CAM_C_ALTERAR 		NVARCHAR(30),
	@IN_CAM_N_REP_N_CODIGO	INT,
	@IN_ALIAS			NVARCHAR(30),
	@IN_FOR_ID			INT
	
) AS
BEGIN
	DECLARE @ORDEMCAMPO1 	INT
	DECLARE @ORDEMCAMPO2 	INT
	DECLARE @CAM_N_ID		INT
	DECLARE @CAM_N_ALTERAR	INT

	SELECT @CAM_N_ID = CAM_N_CODIGO
	FROM RCAM_CAMPOS
	INNER JOIN RREP_REPORTS ON REP_N_MOI_N_CODIGO = CAM_N_REP_N_CODIGO
	WHERE 
		CAM_N_REP_N_CODIGO = @IN_CAM_N_REP_N_CODIGO AND
		CAM_C_ALIAS = @CAM_C_ALTERAR AND
		REP_N_FOR_N_CODIGO = @IN_FOR_ID

	SELECT @CAM_N_ALTERAR = CAM_N_CODIGO
	FROM RCAM_CAMPOS 
	INNER JOIN RREP_REPORTS ON REP_N_MOI_N_CODIGO = CAM_N_REP_N_CODIGO
	WHERE 
		CAM_N_REP_N_CODIGO = @IN_CAM_N_REP_N_CODIGO AND
		CAM_C_ALIAS = @IN_ALIAS AND
		REP_N_FOR_N_CODIGO = @IN_FOR_ID

	--Seleciona ordem do campo 
	SELECT @ORDEMCAMPO2 = CAM_N_ORDEM 
	FROM RCAM_CAMPOS
	INNER JOIN RREP_REPORTS ON REP_N_MOI_N_CODIGO = CAM_N_REP_N_CODIGO
	WHERE 
		CAM_N_REP_N_CODIGO = @IN_CAM_N_REP_N_CODIGO AND
		CAM_C_ALIAS = @IN_ALIAS AND
		REP_N_FOR_N_CODIGO = @IN_FOR_ID

	--Seleciona ordem do campo a ser alterado
	SELECT @ORDEMCAMPO1 = CAM_N_ORDEM 
	FROM RCAM_CAMPOS
	INNER JOIN RREP_REPORTS ON REP_N_MOI_N_CODIGO = CAM_N_REP_N_CODIGO
	WHERE 
		CAM_N_REP_N_CODIGO = @IN_CAM_N_REP_N_CODIGO AND
		CAM_C_ALIAS = @CAM_C_ALTERAR  AND
		REP_N_FOR_N_CODIGO = @IN_FOR_ID

	UPDATE RCAM_CAMPOS 
	SET CAM_N_ORDEM = @ORDEMCAMPO2 
	WHERE CAM_N_CODIGO = @CAM_N_ID

	UPDATE RCAM_CAMPOS 
	SET CAM_N_ORDEM = @ORDEMCAMPO1 
	WHERE CAM_N_CODIGO = @CAM_N_ALTERAR
END
GO

--###########################################################################################################
IF OBJECT_ID('rep_AddFiltrosProcedure') IS NULL
	EXEC('CREATE PROCEDURE rep_AddFiltrosProcedure AS BEGIN	SELECT 1 END')
GO
ALTER PROCEDURE rep_AddFiltrosProcedure (
	 @IN_FIP_N_MOI_N_CODIGO INT,
	 @IN_FIP_C_PARAMETRO VARCHAR(50),
	 @IN_FIP_C_PARAMETRO_VALOR VARCHAR(100),
	 @IN_FIP_C_PARAMETRO_TIPO VARCHAR(50),
	 @IN_FIP_C_TITULO VARCHAR(50),
	 @IN_FIP_B_FILTRO BIT,
	 @IN_FIP_B_NULO BIT
) AS 
BEGIN
	INSERT INTO RFIP_FILTROS_PROCEDURE (
		 FIP_N_MOI_N_CODIGO,
		 FIP_C_PARAMETRO,
		 FIP_C_PARAMETRO_VALOR,
		 FIP_C_PARAMETRO_TIPO,
		 FIP_C_TITULO,
		 FIP_B_FILTRO,
		 FIP_B_NULO
	) VALUES (
		 @IN_FIP_N_MOI_N_CODIGO,
		 @IN_FIP_C_PARAMETRO,
		 @IN_FIP_C_PARAMETRO_VALOR,
		 @IN_FIP_C_PARAMETRO_TIPO,
		 @IN_FIP_C_TITULO,
		 @IN_FIP_B_FILTRO,
		 @IN_FIP_B_NULO			    
	)
END
GO

--###########################################################################################################
IF OBJECT_ID('REP_DELPROCEDURE_REPORTS') IS NULL
	EXEC('CREATE PROCEDURE REP_DELPROCEDURE_REPORTS AS BEGIN	SELECT 1 END')
GO
ALTER PROCEDURE REP_DELPROCEDURE_REPORTS (
	@IN_REP_N_MOI_N_CODIGO		INT,
	@IN_REP_C_PROCEDURE		VARCHAR(100)
) AS
BEGIN
	IF (SELECT COUNT(REP_N_MOI_N_CODIGO) FROM RREP_REPORTS WHERE REP_N_MOI_N_CODIGO = @IN_REP_N_MOI_N_CODIGO AND REP_C_PROCEDURE <> @IN_REP_C_PROCEDURE) > 0
	BEGIN
		--REMOVE PROCEDURE FROM RREP_REPORTS
		
		UPDATE RREP_REPORTS 
		SET 			 
			REP_C_PROCEDURE = @IN_REP_C_PROCEDURE,
			REP_C_PARAMETROS = ''  
		WHERE
			REP_N_MOI_N_CODIGO = @IN_REP_N_MOI_N_CODIGO
			AND REP_C_PROCEDURE <> @IN_REP_C_PROCEDURE
				
		DELETE FROM RFIP_FILTROS_PROCEDURE WHERE FIP_N_MOI_N_CODIGO = @IN_REP_N_MOI_N_CODIGO
			
		DELETE FROM RCAM_CAMPOS WHERE CAM_N_REP_N_CODIGO = @IN_REP_N_MOI_N_CODIGO
	END 
END
GO

--###########################################################################################################
IF OBJECT_ID('REP_DELFILTROSPROCEDURE') IS NULL
	EXEC('CREATE PROCEDURE REP_DELFILTROSPROCEDURE AS BEGIN	SELECT 1 END')
GO
ALTER PROCEDURE REP_DELFILTROSPROCEDURE (
	@IN_FIP_N_MOI_N_CODIGO INT
) AS
BEGIN 
	SET NOCOUNT ON

	DELETE FROM RFIP_FILTROS_PROCEDURE
	WHERE FIP_N_MOI_N_CODIGO = @IN_FIP_N_MOI_N_CODIGO

	SET NOCOUNT OFF
END
GO

--###########################################################################################################
IF OBJECT_ID('REP_LISTCONFFILTROS_PROCEDURE') IS NULL
	EXEC('CREATE PROCEDURE REP_LISTCONFFILTROS_PROCEDURE AS BEGIN	SELECT 1 END')
GO
ALTER PROCEDURE REP_LISTCONFFILTROS_PROCEDURE (
	@IN_FIP_N_MOI_N_CODIGO INTEGER
) AS 
BEGIN
	SELECT
		FIP_N_MOI_N_CODIGO,
		FIP_C_PARAMETRO,
		FIP_C_PARAMETRO_VALOR,
		FIP_C_PARAMETRO_TIPO,
		FIP_C_TITULO,
		FIP_B_FILTRO,
		FIP_B_NULO        
	FROM
		RFIP_FILTROS_PROCEDURE
	WHERE
		FIP_N_MOI_N_CODIGO = @IN_FIP_N_MOI_N_CODIGO
END
GO

--###########################################################################################################
IF OBJECT_ID('rep_DelReport') IS NULL
	EXEC('CREATE PROCEDURE rep_DelReport AS BEGIN	SELECT 1 END')
GO
ALTER PROCEDURE rep_DelReport (@IN_REP_N_MOI_N_CODIGO INT)
AS
BEGIN
	DELETE RREP_REPORTS WHERE REP_N_MOI_N_CODIGO = @IN_REP_N_MOI_N_CODIGO
END
GO

--#####################################################################################################################
--***** DADOS *********************************************************************************************************
--#####################################################################################################################

IF NOT EXISTS (select 1 from sys.indexes where name = 'IX_FORMULARIO_ITEM_PROCESSO__N_CODIGO')
BEGIN
	CREATE NONCLUSTERED INDEX IX_FORMULARIO_ITEM_PROCESSO__N_CODIGO 
		ON FFXI_FORMULARIO_ITEM_PROCESSO (FXI_N_ITE_N_CODIGO ASC)
	WITH (
			PAD_INDEX  = OFF, 
			STATISTICS_NORECOMPUTE  = OFF, 
			SORT_IN_TEMPDB = OFF, 
			IGNORE_DUP_KEY = OFF, 
			DROP_EXISTING = OFF, 
			ONLINE = OFF, 
			ALLOW_ROW_LOCKS  = ON, 
			ALLOW_PAGE_LOCKS  = ON
		)
END
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID('FFXI_FORMULARIO_ITEM_PROCESSO') AND name = 'IX_ITEM_PROCESSO_FULL')
	CREATE NONCLUSTERED INDEX IX_ITEM_PROCESSO_FULL ON FFXI_FORMULARIO_ITEM_PROCESSO (FXI_C_FOR_C_APELIDO, FXI_N_FOR_N_CODAUTOMATICO) INCLUDE (FXI_C_FOR_C_GUID, FXI_N_ITE_N_CODIGO)
GO


--### SET ZURI VERSION ###
begin try
        select * from sys.extended_properties
	declare @v sysname = '9.2025R1.01'--zuriversion
	declare @d varchar(50) = SYSDATETIMEOFFSET()
	if not @v is null and exists (select 1 from sys.extended_properties where class = 0 and name = 'Version')
	begin
		exec sp_updateextendedproperty Version, @v
		exec sp_updateextendedproperty VersionDate, @d
	end 
	else
	begin
		exec sp_addextendedproperty Version, @v
		exec sp_addextendedproperty VersionDate, @d
	end
	select * from sys.extended_properties 
end try
begin catch
end catch

--### Zuri9.2025R1.01 ###  
